function s=ZengLi(A,B)

%
% s=Zengli(A,B)
%
% Compute the similarity between two IT2 FSs A and B using Zeng and Li's
% method:
% 
%  W. Zeng and H. Li, "Relationship between similarity measure and entropy of
%  interval valued fuzzy sets," Fuzzy Sets and Systems, vol. 157, pp.
%  1477--1484, 2006.
%
% Dongrui WU (dongruiw@usc.edu), 7/9/2008
%
% A, B: IT2 FSs each defined by nine parameters (see Fig. 1 in Readme.doc)
%
% s: Similarity

N=200; % number of discretizations
minX=min(A(1),B(1)); % the range
maxX=max(A(4),B(4));
X=linspace(minX,maxX,N);

lowerA=mg(X,A(5:8),[0 A([9 9]) 0]);
upperA=mg(X,A(1:4));
lowerB=mg(X,B(5:8),[0 B([9 9]) 0]);
upperB=mg(X,B(1:4));

s=1-0.5*sum([abs(upperA-upperB),abs(lowerA-lowerB)])/N;

